# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.external_data.base import BaseExternalInfoView
from passport.backend.core.builders.music_api import (
    BaseMusicApiError,
    get_music_api,
)
from passport.backend.core.geobase import Region
from passport.backend.utils.string import smart_str


class MusicAccountStatusView(BaseExternalInfoView):
    oauth_scope = 'music:read'

    external_service_errors = (BaseMusicApiError, )
    use_cache = True
    cache_name = 'music_account_status'

    def get_external_data(self):
        response_data = {'subscription': {}}
        region = Region(ip=self.client_ip)
        if region.country:
            response = get_music_api().account_status(
                uid=self.account.uid,
                user_ticket=self.tvm_user_ticket,
                country_id=region.country['id'],
                user_ip=smart_str(self.client_ip),
            )
            response_data.update(response)
        return response_data
