# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.external_data.base import BaseExternalInfoView
from passport.backend.api.views.bundle.account.external_data.forms import PaginationForm
from passport.backend.api.views.bundle.exceptions import ValidationFailedError
from passport.backend.core.builders.datasync_api import (
    BaseDatasyncApiError,
    get_personality_api,
)
from passport.backend.core.builders.video import (
    BaseVideoApiError,
    get_video_search_api,
    RequestTooLongError,
)
from six.moves.urllib.parse import urlparse


class VideoFavouritesView(BaseExternalInfoView):
    basic_form = PaginationForm

    external_service_errors = (BaseDatasyncApiError, BaseVideoApiError)
    use_cache = False  # Кэшировать бессмысленно, запрос пагинируется

    def _strip_scheme(self, url):
        parsed = urlparse(url)
        return url.replace('%s://' % parsed.scheme, '//', 1)

    def get_external_data(self):
        video_items = get_personality_api().video_favorites(
            uid=self.account.uid,
            limit=self.form_values['page_size'],
            offset=self.form_values['page_size'] * (self.form_values['page'] - 1),
        )

        if video_items:
            try:
                search_results = get_video_search_api().video_info(
                    urls=[item['url'] for item in video_items],
                )
            except RequestTooLongError:
                raise ValidationFailedError(['page_size.too_large'])

            for result in search_results:
                thumbnail = result.get('thumbnail')
                if thumbnail:
                    result.update(
                        thumbnail=self._strip_scheme(thumbnail),
                    )
        else:
            search_results = []

        return {
            'videos': search_results,
        }
