# -*- coding: utf-8 -*-
from passport.backend.core import validators


class BiletApiOrderInfoForm(validators.Schema):
    order_id = validators.ASCIIString(not_empty=True, min=32, max=100)


class PaginationForm(validators.Schema):
    page_size = validators.Int(not_empty=True, if_missing=10, min=1, max=100)
    page = validators.Int(not_empty=True, if_missing=1, min=1)


class AfishaFavouritesForm(PaginationForm):
    # В днях
    period = validators.Int(if_missing=180, min=1)


class MapsBookmarkInfoForm(validators.Schema):
    uri = validators.String(not_empty=True, strip=True)
    language = validators.PortalLanguage()
