# -*- coding: utf-8 -*-
from datetime import (
    datetime,
    timedelta,
)

from passport.backend.core import validators
from passport.backend.core.conf import settings


ACCOUNT_HISTORY_HOURS_LIMIT = 24 * 365 * 30
CHALLENGE_MAX_TIMEDELTA = timedelta(days=30)  # дольше historydb не хранит


class HistoryForm(validators.Schema):
    uid = validators.Uid(not_empty=True, if_missing=None)
    from_auth_row = validators.String(strip=True, if_missing=None, if_empty=None)
    password_auths = validators.StringBoolean(not_empty=True, strip=True, if_missing=None)
    hours_limit = validators.Int(
        min=1,
        max=ACCOUNT_HISTORY_HOURS_LIMIT,
        not_empty=True,
        strip=True,
        if_missing=None,
    )

    def __init__(self, *args, **kwargs):
        self.add_field(
            'limit',
            validators.Int(
                min=1,
                max=settings.ACCOUNT_HISTORY_MAX_LIMIT,
                not_empty=True,
                if_missing=settings.ACCOUNT_HISTORY_DEFAULT_LIMIT,
            ),
        )
        super(HistoryForm, self).__init__(*args, **kwargs)


class ChallengeForm(validators.Schema):
    uid = validators.Uid(not_empty=True, if_missing=None)

    def __init__(self, *args, **kwargs):
        self.add_field(
            'challenge_time',
            validators.Unixtime(
                min=datetime.now() - CHALLENGE_MAX_TIMEDELTA,
                max=datetime.now(),
                allow_milliseconds=True,
            ),
        )
        super(ChallengeForm, self).__init__(*args, **kwargs)
