# -*- coding: utf-8 -*-
from passport.backend.core import validators


DEFAULT_TARGET = 'default'
EVERYBODY_TARGET = 'everybody'


class LogoutForm(validators.Schema):
    yu = validators.String(if_missing=None, strip=True)
    ci = validators.String(if_missing=None, strip=True)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True)
    origin = validators.String(if_missing=None, strip=True)
    is_global = validators.StringBool(if_missing=False)
    target = validators.OneOf(
        [EVERYBODY_TARGET, DEFAULT_TARGET],
        if_invalid=DEFAULT_TARGET,
        if_empty=DEFAULT_TARGET,
        if_missing=DEFAULT_TARGET,
        strip=True,
    )

    chained_validators = [
        validators.RequireSome(
            [
                'yu',
                'ci',
            ],
            min_=1,
            max_=1,
            empty_values=[None, ''],
        ),
    ]
