from passport.backend.api.templatetags import l
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.headers import (
    HEADER_CLIENT_HOST,
    HEADER_CONSUMER_CLIENT_IP,
)
from passport.backend.api.views.bundle.mixins.account import (
    BundleAccountGetterMixin,
    UserMetaDataMixin,
)
from passport.backend.api.views.bundle.mixins.kolmogor import KolmogorMixin
from passport.backend.api.views.bundle.mixins.mail import MailMixin
from passport.backend.api.views.bundle.mixins.push import BundlePushMixin
from passport.backend.core.models.account import get_preferred_language

from .forms import AccountModificationNotifyForm


ACCOUNT_MODIFICATION_NOTIFY_GRANT = 'account.modification_notify'


class AccountModificationNotify(
    MailMixin,
    UserMetaDataMixin,
    BaseBundleView,
    BundleAccountGetterMixin,
    BundlePushMixin,
    KolmogorMixin,
):
    basic_form = AccountModificationNotifyForm

    required_grants = [ACCOUNT_MODIFICATION_NOTIFY_GRANT]
    required_headers = (
        HEADER_CONSUMER_CLIENT_IP,
        HEADER_CLIENT_HOST,
    )

    require_track = False

    def process_request(self):
        self.process_basic_form()
        self.get_account_by_uid(uid=self.form_values['uid'], emails=True)
        if self.form_values['push_enabled']:
            self.send_account_modification_push(
                event_name=self.form_values['event_name'],
            )
        if self.form_values['mail_enabled']:
            context = dict()
            if self.form_values['event_name'] == 'social_add':
                context.update(
                    PROVIDER=l(
                        dict(),
                        'SOCIAL',
                        self.form_values.get('social_provider', ''),
                        get_preferred_language(self.account),
                    ),
                )

            self.send_account_modification_mail(
                event_name=self.form_values['event_name'],
                context=context,
            )
