from passport.backend.core import validators
from passport.backend.core.conf import settings


class AccountModificationNotifyForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    mail_enabled = validators.StringBool(if_missing=None)
    push_enabled = validators.StringBool(if_missing=None)
    social_provider = validators.String(if_missing=None)

    def __init__(self):
        super(AccountModificationNotifyForm, self).__init__()
        self.add_field(
            'event_name',
            validators.OneOf(
                settings.ACCOUNT_MODIFICATION_MAIL_ENABLE | settings.ACCOUNT_MODIFICATION_PUSH_ENABLE,
                not_empty=True,
            ),
        )
