# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.options.grants import (
    ACCOUNT_AUDIENCE_ON_GRANT_PREFIX,
    ACCOUNT_FAMILY_PAY_ENABLED_GRANT_PREFIX,
    ACCOUNT_FORCE_CHALLENGE_GRANT_PREFIX,
    ACCOUNT_FORRBID_DISABLING_SMS_2FA_GRANT_PREFIX,
    ACCOUNT_GLOBAL_LOGOUT_GRANT,
    ACCOUNT_GLOBAL_LOGOUT_GRANT_PREFIX,
    ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT,
    ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT_PREFIX,
    ACCOUNT_IS_CONNECT_ADMIN_GRANT,
    ACCOUNT_IS_CONNECT_ADMIN_GRANT_PREFIX,
    ACCOUNT_IS_DOCUMENTS_AGREEMENT_ACCEPTED_GRANT_PREFIX,
    ACCOUNT_IS_DZEN_SSO_PROHIBITED_GRANT_PREFIX,
    ACCOUNT_CAN_MANAGE_CHILDREN_GRANT_PREFIX,
    ACCOUNT_IS_EASILY_HACKED_GRANT,
    ACCOUNT_IS_EASILY_HACKED_GRANT_PREFIX,
    ACCOUNT_IS_ENABLED_GRANT,
    ACCOUNT_IS_ENABLED_GRANT_PREFIX,
    ACCOUNT_IS_MAILBOX_FROZEN_GRANT_PREFIX,
    ACCOUNT_IS_MAILLIST_GRANT,
    ACCOUNT_IS_MAILLIST_GRANT_PREFIX,
    ACCOUNT_IS_SHARED_GRANT,
    ACCOUNT_IS_SHARED_GRANT_PREFIX,
    ACCOUNT_PERSONAL_DATA_PUBLIC_ACCESS_ALLOWED_GRANT_PREFIX,
    ACCOUNT_PERSONAL_DATA_THIRD_PARTY_PROCESSING_ALLOWED_GRANT_PREFIX,
    ACCOUNT_PLUS_CASHBACK_ENABLED_GRANT_PREFIX,
    ACCOUNT_PLUS_ENABLED_GRANT_PREFIX,
    ACCOUNT_PLUS_FAMILY_ROLE_GRANT_PREFIX,
    ACCOUNT_PLUS_IS_FROZEN_GRANT_PREFIX,
    ACCOUNT_PLUS_NEXT_CHARGE_TS_GRANT_PREFIX,
    ACCOUNT_PLUS_OTT_SUBSCRIPTION_GRANT_PREFIX,
    ACCOUNT_PLUS_SUBSCRIBER_STATE_GRANT_PREFIX,
    ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS_GRANT_PREFIX,
    ACCOUNT_PLUS_SUBSCRIPTION_LEVEL_GRANT_PREFIX,
    ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS_GRANT_PREFIX,
    ACCOUNT_PLUS_TRIAL_USED_TS_GRANT_PREFIX,
    ACCOUNT_REVOKE_APP_PASSWORDS_GRANT,
    ACCOUNT_REVOKE_APP_PASSWORDS_GRANT_PREFIX,
    ACCOUNT_REVOKE_TOKENS_GRANT,
    ACCOUNT_REVOKE_TOKENS_GRANT_PREFIX,
    ACCOUNT_REVOKE_WEB_SESSIONS_GRANT,
    ACCOUNT_REVOKE_WEB_SESSIONS_GRANT_PREFIX,
    ACCOUNT_SET_BILLING_FEATURES_GRANT,
    ACCOUNT_SET_BILLING_FEATURES_GRANT_PREFIX,
    ACCOUNT_SMS_2FA_ON_GRANT_PREFIX,
    ALLOW_TAKEOUT_DELETE_SUBSCRIPTION_GRANT_PREFIX,
    ALLOW_TAKEOUT_SUBSCRIPTION_GRANT,
    ALLOW_TAKEOUT_SUBSCRIPTION_GRANT_PREFIX,
    DISABLE_AUTH_METHODS_GRANT,
    DISABLE_AUTH_METHODS_GRANT_PREFIX,
    EXTERNAL_ORGANIZATION_IDS_GRANT,
    EXTERNAL_ORGANIZATION_IDS_GRANT_PREFIX,
    PASSWORD_IS_CHANGING_REQUIRED_GRANT,
    PASSWORD_IS_CHANGING_REQUIRED_GRANT_PREFIX,
    PASSWORD_UPDATE_DATETIME_GRANT,
    PASSWORD_UPDATE_DATETIME_GRANT_PREFIX,
    PERSON_SHOW_FIO_IN_PUBLIC_NAME_GRANT_PREFIX,
)
from passport.backend.api.views.bundle.account.options.handlers import (
    BaseValueHandler,
    DatetimeNowHandler,
    DisableAuthMethodsHandler,
    IsMailboxFrozenHandler,
    IsMailListHandler,
    IsPasswordChangeRequiredHandler,
    PlusEnableDisableHandler,
    Sms2FaOnHandler,
    UnixtimeHandler,
    CanManageChildrenHandler,
)


DEFAULT_CONFIG = {
    'handler': BaseValueHandler,
}


CUSTOM_CONFIGS = {
    'is_enabled': {
        'old_style_grants': [ACCOUNT_IS_ENABLED_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_ENABLED_GRANT_PREFIX,
    },
    'is_app_password_enabled': {
        'old_style_grants': [ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT_PREFIX,
        'account_attribute_name': 'enable_app_password',
    },
    'is_shared': {
        'old_style_grants': [ACCOUNT_IS_SHARED_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_SHARED_GRANT_PREFIX,
    },
    'is_connect_admin': {
        'old_style_grants': [ACCOUNT_IS_CONNECT_ADMIN_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_CONNECT_ADMIN_GRANT_PREFIX,
    },
    'is_maillist': {
        'old_style_grants': [ACCOUNT_IS_MAILLIST_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_MAILLIST_GRANT_PREFIX,
        'handler': IsMailListHandler,
    },
    'is_easily_hacked': {
        'old_style_grants': [ACCOUNT_IS_EASILY_HACKED_GRANT],
        'new_style_grant_prefix': ACCOUNT_IS_EASILY_HACKED_GRANT_PREFIX,
        'account_attribute_name': 'is_easily_hacked',
    },
    'revoke_web_sessions': {
        'old_style_grants': [ACCOUNT_REVOKE_WEB_SESSIONS_GRANT],
        'new_style_grant_prefix': ACCOUNT_REVOKE_WEB_SESSIONS_GRANT_PREFIX,
        'account_attribute_name': 'web_sessions_revoked_at',
        'handler': DatetimeNowHandler,
    },
    'global_logout': {
        'old_style_grants': [ACCOUNT_GLOBAL_LOGOUT_GRANT],
        'new_style_grant_prefix': ACCOUNT_GLOBAL_LOGOUT_GRANT_PREFIX,
        'account_attribute_name': 'global_logout_datetime',
        'handler': DatetimeNowHandler,
    },
    'revoke_tokens': {
        'old_style_grants': [ACCOUNT_REVOKE_TOKENS_GRANT],
        'new_style_grant_prefix': ACCOUNT_REVOKE_TOKENS_GRANT_PREFIX,
        'account_attribute_name': 'tokens_revoked_at',
        'handler': DatetimeNowHandler,
    },
    'revoke_app_passwords': {
        'old_style_grants': [ACCOUNT_REVOKE_APP_PASSWORDS_GRANT],
        'new_style_grant_prefix': ACCOUNT_REVOKE_APP_PASSWORDS_GRANT_PREFIX,
        'account_attribute_name': 'app_passwords_revoked_at',
        'handler': DatetimeNowHandler,
    },
    'password_update_timestamp': {
        'old_style_grants': [PASSWORD_UPDATE_DATETIME_GRANT],
        'new_style_grant_prefix': PASSWORD_UPDATE_DATETIME_GRANT_PREFIX,
        'account_attribute_name': 'password.update_datetime',
        'handler': UnixtimeHandler,
    },
    'is_password_change_required': {
        'old_style_grants': [PASSWORD_IS_CHANGING_REQUIRED_GRANT],
        'new_style_grant_prefix': PASSWORD_IS_CHANGING_REQUIRED_GRANT_PREFIX,
        'account_attribute_name': 'password.is_changing_required',
        'handler': IsPasswordChangeRequiredHandler,
        'raise_if_nothing_to_do': True,  # PASSP-13047
    },
    'audience_on': {
        'old_style_grants': [],
        'new_style_grant_prefix': ACCOUNT_AUDIENCE_ON_GRANT_PREFIX,
        'account_attribute_name': 'audience_on',
    },
    'external_organization_ids': {
        'old_style_grants': [EXTERNAL_ORGANIZATION_IDS_GRANT],
        'new_style_grant_prefix': EXTERNAL_ORGANIZATION_IDS_GRANT_PREFIX,
        'account_attribute_name': 'external_organization_ids',
    },
    'magic_link_login_forbidden': {
        'old_style_grants': [DISABLE_AUTH_METHODS_GRANT],
        'new_style_grant_prefix': DISABLE_AUTH_METHODS_GRANT_PREFIX,
        'account_attribute_name': 'magic_link_login_forbidden',
        'handler': DisableAuthMethodsHandler,
    },
    'qr_code_login_forbidden': {
        'old_style_grants': [DISABLE_AUTH_METHODS_GRANT],
        'new_style_grant_prefix': DISABLE_AUTH_METHODS_GRANT_PREFIX,
        'account_attribute_name': 'qr_code_login_forbidden',
        'handler': DisableAuthMethodsHandler,
    },
    'sms_code_login_forbidden': {
        'old_style_grants': [DISABLE_AUTH_METHODS_GRANT],
        'new_style_grant_prefix': DISABLE_AUTH_METHODS_GRANT_PREFIX,
        'account_attribute_name': 'sms_code_login_forbidden',
        'handler': DisableAuthMethodsHandler,
    },
    'takeout_subscription': {
        'old_style_grants': [ALLOW_TAKEOUT_SUBSCRIPTION_GRANT],
        'new_style_grant_prefix': ALLOW_TAKEOUT_SUBSCRIPTION_GRANT_PREFIX,
        'account_attribute_name': 'takeout.subscription',
    },
    'billing_features': {
        'old_style_grants': [ACCOUNT_SET_BILLING_FEATURES_GRANT],
        'new_style_grant_prefix': ACCOUNT_SET_BILLING_FEATURES_GRANT_PREFIX,
        'account_attribute_name': 'billing_features',
    },
    'show_fio_in_public_name': {
        'old_style_grants': None,
        'new_style_grant_prefix': PERSON_SHOW_FIO_IN_PUBLIC_NAME_GRANT_PREFIX,
        'account_attribute_name': 'person.show_fio_in_public_name',
    },
    'force_challenge': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_FORCE_CHALLENGE_GRANT_PREFIX,
        'account_attribute_name': 'force_challenge',
    },
    'sms_2fa_on': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_SMS_2FA_ON_GRANT_PREFIX,
        'account_attribute_name': 'sms_2fa_on',
        'handler': Sms2FaOnHandler,
    },
    'forbid_disabling_sms_2fa': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_FORRBID_DISABLING_SMS_2FA_GRANT_PREFIX,
        'account_attribute_name': 'forbid_disabling_sms_2fa',
    },
    'takeout_delete_subscription': {
        'old_style_grants': None,
        'new_style_grant_prefix': ALLOW_TAKEOUT_DELETE_SUBSCRIPTION_GRANT_PREFIX,
        'account_attribute_name': 'takeout.delete_subscription',
    },
    'is_mailbox_frozen': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_IS_MAILBOX_FROZEN_GRANT_PREFIX,
        'handler': IsMailboxFrozenHandler,
    },
    'personal_data_public_access_allowed': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PERSONAL_DATA_PUBLIC_ACCESS_ALLOWED_GRANT_PREFIX,
        'account_attribute_name': 'personal_data_public_access_allowed',
    },
    'personal_data_third_party_processing_allowed': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PERSONAL_DATA_THIRD_PARTY_PROCESSING_ALLOWED_GRANT_PREFIX,
        'account_attribute_name': 'personal_data_third_party_processing_allowed',
    },
    'family_pay_enabled': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_FAMILY_PAY_ENABLED_GRANT_PREFIX,
        'account_attribute_name': 'family_pay_enabled',
    },
    'plus_enabled': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_ENABLED_GRANT_PREFIX,
        'account_attribute_name': 'plus.enabled',
        'handler': PlusEnableDisableHandler,
    },
    'plus_trial_used_ts': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_TRIAL_USED_TS_GRANT_PREFIX,
        'account_attribute_name': 'plus.trial_used_ts',
    },
    'plus_subscription_stopped_ts': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS_GRANT_PREFIX,
        'account_attribute_name': 'plus.subscription_stopped_ts',
    },
    'plus_subscription_expire_ts': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS_GRANT_PREFIX,
        'account_attribute_name': 'plus.subscription_expire_ts',
    },
    'plus_next_charge_ts': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_NEXT_CHARGE_TS_GRANT_PREFIX,
        'account_attribute_name': 'plus.next_charge_ts',
    },
    'ott_subscription': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_OTT_SUBSCRIPTION_GRANT_PREFIX,
        'account_attribute_name': 'plus.ott_subscription',
    },
    'plus_family_role': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_FAMILY_ROLE_GRANT_PREFIX,
        'account_attribute_name': 'plus.family_role',
    },
    'plus_cashback_enabled': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_CASHBACK_ENABLED_GRANT_PREFIX,
        'account_attribute_name': 'plus.cashback_enabled',
    },
    'plus_subscription_level': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_SUBSCRIPTION_LEVEL_GRANT_PREFIX,
        'account_attribute_name': 'plus.subscription_level',
    },
    'plus_is_frozen': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_IS_FROZEN_GRANT_PREFIX,
        'account_attribute_name': 'plus.is_frozen',
    },
    'plus_subscriber_state': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_PLUS_SUBSCRIBER_STATE_GRANT_PREFIX,
        'account_attribute_name': 'plus.subscriber_state',
    },
    'is_documents_agreement_accepted': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_IS_DOCUMENTS_AGREEMENT_ACCEPTED_GRANT_PREFIX,
        'account_attribute_name': 'is_documents_agreement_accepted',
    },
    'is_dzen_sso_prohibited': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_IS_DZEN_SSO_PROHIBITED_GRANT_PREFIX,
        'account_attribute_name': 'is_dzen_sso_prohibited',
    },
    'can_manage_children': {
        'old_style_grants': None,
        'new_style_grant_prefix': ACCOUNT_CAN_MANAGE_CHILDREN_GRANT_PREFIX,
        'account_attribute_name': 'can_manage_children',
        'handler': CanManageChildrenHandler,
    },
}


ACCOUNT_OPTIONS_CONFIG = {
    attr_name: dict(DEFAULT_CONFIG, **custom_config)
    for attr_name, custom_config in CUSTOM_CONFIGS.items()
}


def plus_attribute(option_name, handler=BaseValueHandler):
    return {
        'account_attribute_name': option_name,
        'handler': handler,
        'old_style_grants': [],
        'new_style_grant_prefix': None,
        'is_plus': True,
    }


PLUS_ATTRIBUTES_CONFIG = {
    'plus_enabled': plus_attribute('plus.enabled', handler=PlusEnableDisableHandler),
    'plus_trial_used_ts': plus_attribute('plus.trial_used_ts'),
    'plus_subscription_stopped_ts': plus_attribute('plus.subscription_stopped_ts'),
    'plus_subscription_expire_ts': plus_attribute('plus.subscription_expire_ts'),
    'plus_next_charge_ts': plus_attribute('plus.next_charge_ts'),
    'ott_subscription': plus_attribute('plus.ott_subscription'),
    'plus_family_role': plus_attribute('plus.family_role'),
    'plus_cashback_enabled': plus_attribute('plus.cashback_enabled'),
    'plus_subscription_level': plus_attribute('plus.subscription_level'),
    'plus_is_frozen': plus_attribute('plus.is_frozen'),
}
