# -*- coding: utf-8 -*-

# базовые гранты
ACCOUNT_OPTIONS_BASE_GRANT = 'account_options.base'
LOG_ADMIN_ACTION_GRANT = 'admin.log_action'

PLUS_OPTIONS_BASE_GRANT = 'plus.change_attributes'

# гранты старого вида на тип аккаунта (не связаны с грантами на конкретные атрибуты)
ACCOUNT_OPTIONS_ANY_GRANT = 'account_options.any'
ACCOUNT_OPTIONS_NORMAL_GRANT = 'account_options.normal'
ACCOUNT_OPTIONS_PDD_GRANT = 'account_options.pdd'
ACCOUNT_OPTIONS_PHONISH_GRANT = 'account_options.phonish'

# гранты старого вида на конкретные атрибуты (не связаны с грантами на тип аккаунта)
ACCOUNT_IS_ENABLED_GRANT = 'account.is_enabled'
ACCOUNT_IS_MAILLIST_GRANT = 'account.is_maillist'
ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT = 'account.enable_app_password__full_control'
ACCOUNT_IS_SHARED_GRANT = 'account.is_shared'
PASSWORD_IS_CHANGING_REQUIRED_GRANT = 'password.is_changing_required'
ACCOUNT_GLOBAL_LOGOUT_GRANT = 'account.global_logout'
ACCOUNT_REVOKE_TOKENS_GRANT = 'account.revoke_tokens'
ACCOUNT_REVOKE_APP_PASSWORDS_GRANT = 'account.revoke_app_passwords'
ACCOUNT_REVOKE_WEB_SESSIONS_GRANT = 'account.revoke_web_sessions'
PASSWORD_UPDATE_DATETIME_GRANT = 'password.update_datetime'
ACCOUNT_SHOW_2FA_PROMO_GRANT = 'account.show_2fa_promo'
ACCOUNT_IS_CONNECT_ADMIN_GRANT = 'account.is_connect_admin'
ACCOUNT_IS_EASILY_HACKED_GRANT = 'account.is_easily_hacked'
EXTERNAL_ORGANIZATION_IDS_GRANT = 'account.external_organization_ids'
DISABLE_AUTH_METHODS_GRANT = 'account.disable_auth_methods'
ALLOW_TAKEOUT_SUBSCRIPTION_GRANT = 'takeout.subscription'
ACCOUNT_SET_BILLING_FEATURES_GRANT = 'account.set_billing_features'

# гранты нового вида (формируются по правилу <префикс на атрибут>.<постфикс на тип аккаунта или тип креденшла>)
POSTFIX_BY_UID = 'by_uid'

POSTFIX_ACCOUNT_TYPE_ANY = 'any'
POSTFIX_ACCOUNT_TYPE_NORMAL = 'normal'
POSTFIX_ACCOUNT_TYPE_PDD = 'pdd'
POSTFIX_ACCOUNT_TYPE_PHONISH = 'phonish'
POSTFIX_ACCOUNT_TYPE_FEDERAL = 'federal'
ACCOUNT_TYPE_TO_POSTFIX = {
    'any': POSTFIX_ACCOUNT_TYPE_ANY,
    'normal': POSTFIX_ACCOUNT_TYPE_NORMAL,
    'pdd': POSTFIX_ACCOUNT_TYPE_PDD,
    'phonish': POSTFIX_ACCOUNT_TYPE_PHONISH,
    'federal': POSTFIX_ACCOUNT_TYPE_FEDERAL,
}

ACCOUNT_IS_ENABLED_GRANT_PREFIX = 'account_options.is_enabled'
ACCOUNT_IS_MAILLIST_GRANT_PREFIX = 'account_options.is_maillist'
ACCOUNT_IS_APP_PASSWORD_ENABLED_GRANT_PREFIX = 'account_options.enable_app_password__full_control'
ACCOUNT_IS_SHARED_GRANT_PREFIX = 'account_options.is_shared'
PASSWORD_IS_CHANGING_REQUIRED_GRANT_PREFIX = 'account_options.is_password_changing_required'
ACCOUNT_GLOBAL_LOGOUT_GRANT_PREFIX = 'account_options.global_logout'
ACCOUNT_REVOKE_TOKENS_GRANT_PREFIX = 'account_options.revoke_tokens'
ACCOUNT_REVOKE_APP_PASSWORDS_GRANT_PREFIX = 'account_options.revoke_app_passwords'
ACCOUNT_REVOKE_WEB_SESSIONS_GRANT_PREFIX = 'account_options.revoke_web_sessions'
PASSWORD_UPDATE_DATETIME_GRANT_PREFIX = 'account_options.password_update_datetime'
ACCOUNT_AUDIENCE_ON_GRANT_PREFIX = 'account_options.audience_on'
ACCOUNT_IS_CONNECT_ADMIN_GRANT_PREFIX = 'account_options.is_connect_admin'
ACCOUNT_IS_EASILY_HACKED_GRANT_PREFIX = 'account_options.is_easily_hacked'
EXTERNAL_ORGANIZATION_IDS_GRANT_PREFIX = 'account_options.external_organization_ids'
DISABLE_AUTH_METHODS_GRANT_PREFIX = 'account_options.disable_auth_methods'
ALLOW_TAKEOUT_SUBSCRIPTION_GRANT_PREFIX = 'account_options.takeout_subscription'
ACCOUNT_SET_BILLING_FEATURES_GRANT_PREFIX = 'account_options.set_billing_features'
PERSON_SHOW_FIO_IN_PUBLIC_NAME_GRANT_PREFIX = 'account_options.show_fio_in_public_name'
ACCOUNT_FORCE_CHALLENGE_GRANT_PREFIX = 'account_options.force_challenge'
ACCOUNT_SMS_2FA_ON_GRANT_PREFIX = 'account_options.sms_2fa_on'
ACCOUNT_FORRBID_DISABLING_SMS_2FA_GRANT_PREFIX = 'account_options.forbid_disabling_sms_2fa'
ALLOW_TAKEOUT_DELETE_SUBSCRIPTION_GRANT_PREFIX = 'account_options.takeout_delete_subscription'
ACCOUNT_IS_MAILBOX_FROZEN_GRANT_PREFIX = 'account_options.is_mailbox_frozen'
ACCOUNT_PERSONAL_DATA_PUBLIC_ACCESS_ALLOWED_GRANT_PREFIX = 'account_options.personal_data_public_access_allowed'
ACCOUNT_PERSONAL_DATA_THIRD_PARTY_PROCESSING_ALLOWED_GRANT_PREFIX = 'account_options.personal_data_third_party_processing_allowed'
ACCOUNT_FAMILY_PAY_ENABLED_GRANT_PREFIX = 'account_options.family_pay_enabled'
ACCOUNT_PLUS_ENABLED_GRANT_PREFIX = 'account_options.plus_enabled'
ACCOUNT_PLUS_TRIAL_USED_TS_GRANT_PREFIX = 'account_options.plus_trial_used_ts'
ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS_GRANT_PREFIX = 'account_options.plus_subscription_stopped_ts'
ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS_GRANT_PREFIX = 'account_options.plus_subscription_expire_ts'
ACCOUNT_PLUS_NEXT_CHARGE_TS_GRANT_PREFIX = 'account_options.plus_next_charge_ts'
ACCOUNT_PLUS_OTT_SUBSCRIPTION_GRANT_PREFIX = 'account_options.ott_subscription'
ACCOUNT_PLUS_FAMILY_ROLE_GRANT_PREFIX = 'account_options.plus_family_role'
ACCOUNT_PLUS_CASHBACK_ENABLED_GRANT_PREFIX = 'account_options.plus_cashback_enabled'
ACCOUNT_PLUS_SUBSCRIPTION_LEVEL_GRANT_PREFIX = 'account_options.plus_subscription_level'
ACCOUNT_PLUS_IS_FROZEN_GRANT_PREFIX = 'account_options.plus_is_frozen'
ACCOUNT_PLUS_SUBSCRIBER_STATE_GRANT_PREFIX = 'account_options.plus_subscriber_state'
ACCOUNT_IS_DOCUMENTS_AGREEMENT_ACCEPTED_GRANT_PREFIX = 'account_options.is_documents_agreement_accepted'
ACCOUNT_IS_DZEN_SSO_PROHIBITED_GRANT_PREFIX = 'account_options.is_dzen_sso_prohibited'
ACCOUNT_CAN_MANAGE_CHILDREN_GRANT_PREFIX = 'account_options.can_manage_children'
