# -*- coding: utf-8 -*-


class Options(object):
    def __init__(self, view, config):
        self.view = view
        self.config = config

    def _passed_option_names(self):
        passed_option_names = [k for k, v in self.view.form_values.items() if v is not None]
        all_option_names = self.config.keys()
        return set(passed_option_names) & set(all_option_names)

    def _run(self, method_name):
        for option_name in self._passed_option_names():
            option_params = self.config[option_name]
            handler_class = option_params['handler']
            handler = handler_class(self.view, option_name, option_params)
            getattr(handler, method_name)()

    def pre_update(self):
        self._run('pre_update')

    def update(self):
        self._run('update')

    def post_update(self):
        self._run('post_update')
