# -*- coding: utf-8 -*-


def attrsetter(attr, value):
    def wrapper(obj):
        parts = attr.split('.')
        last_part = parts[-1]
        prev_parts = parts[:-1]
        for part in prev_parts:
            obj = getattr(obj, part)
        setattr(obj, last_part, value)
    return wrapper
