# -*- coding: utf-8 -*-
from passport.backend.core import validators


class AccountPhonishCanLoginForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    phone_number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(),
    ]


class AccountPhonishDisableAuthForm(validators.Schema):
    uid = validators.Uid(not_empty=True)

    # Имя админа и его комментарий для лога
    admin_name = validators.String(if_missing=None, not_empty=True, strip=True)
    comment = validators.String(if_missing=None, not_empty=True, strip=True)

    chained_validators = [
        validators.RequireSet([('admin_name', 'comment')], allow_empty=True),
    ]


class AccountPhonishUidByPhoneForm(validators.Schema):
    use_device_id = validators.StringBoolean(not_empty=True, if_missing=False)
