# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.exceptions import (
    AccountDisabledError,
    OAuthTokenValidationError,
)
from passport.backend.api.views.bundle.headers import (
    HEADER_CONSUMER_AUTHORIZATION,
    HEADER_CONSUMER_CLIENT_IP,
)
from passport.backend.api.views.bundle.mixins import BundleAccountGetterMixin
from passport.backend.core.builders.blackbox.constants import (
    BLACKBOX_OAUTH_DISABLED_STATUS,
    BLACKBOX_OAUTH_VALID_STATUS,
)
from passport.backend.core.logging_utils.loggers.statbox import StatboxLogger
from passport.backend.core.utils.decorators import cached_property


class SecretsBaseView(BaseBundleView, BundleAccountGetterMixin):
    mode = None
    oauth_scope = None

    require_track = False
    required_headers = [HEADER_CONSUMER_CLIENT_IP, HEADER_CONSUMER_AUTHORIZATION]

    @cached_property
    def statbox(self):
        return StatboxLogger(
            mode=self.mode,
            ip=self.client_ip,
        )

    def validate_token_and_parse_account(self):
        # Провалидируем токен в ЧЯ
        response = self.blackbox.oauth(
            self.oauth_token,
            ip=self.client_ip,
        )
        if response['status'] != BLACKBOX_OAUTH_VALID_STATUS:
            self.statbox.log(status='error', reason='invalid_token', bb_status=response['status'])
            if response['status'] == BLACKBOX_OAUTH_DISABLED_STATUS:
                raise AccountDisabledError()
            else:
                raise OAuthTokenValidationError()

        if self.oauth_scope not in response['oauth']['scope']:
            self.statbox.log(status='error', reason='insufficient_token_scopes')
            raise OAuthTokenValidationError()

        self.parse_account(response)
        self.statbox.bind(uid=self.account.uid)
