# -*- coding: utf-8 -*-
import logging

from passport.backend.core.runner.context_managers import UPDATE

from .base import SecretsBaseView
from .forms import SecretsWriteBrowserKeyForm


log = logging.getLogger('passport.api.view.bundle.account.secrets')

BROWSER_KEY_GRANT = 'account.browser_key'
BROWSER_KEY_OAUTH_SCOPE = 'yadisk:browser_sync'


class SecretsBrowserKeyBaseView(SecretsBaseView):
    mode = 'account_secrets_browser_key'
    oauth_scope = BROWSER_KEY_OAUTH_SCOPE
    required_grants = [BROWSER_KEY_GRANT]


class SecretsReadBrowserKeyView(SecretsBrowserKeyBaseView):

    def process_request(self, *args, **kwargs):
        self.validate_token_and_parse_account()
        self.statbox.log(action='read')
        # не используем b64encode - от ЧЯ уже пришёл base64
        self.response_values['browser_key'] = self.account.browser_key.key or ''


class SecretsWriteBrowserKeyView(SecretsBrowserKeyBaseView):

    basic_form = SecretsWriteBrowserKeyForm

    def process_request(self, *args, **kwargs):
        self.process_basic_form()
        self.validate_token_and_parse_account()
        events = {
            'action': 'browser_key',
            'consumer': self.consumer,
        }
        with UPDATE(
            self.account,
            self.request.env,
            events,
            force_history_db_external_events=True,
        ):
            browser_key = self.form_values['browser_key']
            if self.form_values['append']:
                self.account.browser_key.append(browser_key)
            else:
                self.account.browser_key.set(browser_key)

        self.statbox.log(action='saved')


class SecretsDeleteBrowserKeyView(SecretsBrowserKeyBaseView):

    def process_request(self, *args, **kwargs):
        self.validate_token_and_parse_account()
        events = {
            'action': 'browser_key',
            'consumer': self.consumer,
        }
        with UPDATE(
            self.account,
            self.request.env,
            events,
            force_history_db_external_events=True,
        ):
            self.account.browser_key.set(None)

        self.statbox.log(action='deleted')
