# -*- coding: utf-8 -*-
from passport.backend.core import validators


class SecretsWriteBrowserKeyForm(validators.Schema):
    """Форма записи ключа для Браузера"""
    browser_key = validators.Base64String(strip=True, not_empty=True, max=64)  # реальные ключи - около 44
    append = validators.StringBool(strip=True, not_empty=True, if_missing=False)


class SecretsReadPassmanRecoveryKeyForm(validators.Schema):
    """Форма чтения ключа сброса пароля для Браузера"""
    uid = validators.Uid(if_missing=None)
    key_id = validators.Base64String(strip=True, not_empty=True, max=100)  # реальные значения - около 86


class SecretsWritePassmanRecoveryKeyForm(SecretsReadPassmanRecoveryKeyForm):
    """Форма записи ключа сброса пароля для Браузера"""
    recovery_key = validators.Base64String(strip=True, not_empty=True, max=100)  # реальные значения - около 86
