# -*- coding: utf-8 -*-
from passport.backend.core import validators


class SubscribeForm(validators.Schema):
    service = validators.Service(not_empty=True, strip=True, ignore_unknown_service=True)
    retpath = validators.RetPath(if_missing=None, strip=True)


class UnsubscribeSubmitForm(validators.Schema):
    """Форма получения информации для отписки пользователя от какого-то сервиса"""
    service = validators.Service(not_empty=True)
    retpath = validators.RetPath(if_missing=None, strip=True)


class UnsubscribeCommitForm(validators.Schema):
    """Форма для выполнения отписки пользователя от какого-то сервиса после проверок"""
    password = validators.String(not_empty=True)
