# -*- coding: utf-8 -*-

import re

from passport.backend.core import validators


class DriveSessionIdValidator(validators.String):
    strip = True
    not_empty = True


class StartForm(validators.Schema):
    drive_device_id = validators.DriveDeviceIdValidator()
    drive_session_id = DriveSessionIdValidator()


StopForm = StartForm


class BuildNonceForm(validators.Schema):
    drive_device_id = validators.DriveDeviceIdValidator()


class IssueAuthorizationCodeForm(validators.Schema):
    drive_device_id = validators.DriveDeviceIdValidator()
    sandbox_device_id = validators.DriveDeviceIdValidator(if_missing=None)
    nonce = validators.SignatureValidator()
    signature = validators.SignatureValidator()
    oauth_client_id = validators.String(not_empty=True, strip=True, if_missing=None)
    oauth_client_secret = validators.String(not_empty=True, strip=True, if_missing=None)
    test_drive_session_id = DriveSessionIdValidator(if_missing=None)
    check_drive_session = validators.StringBool(if_missing=True)
