# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class BaseAuthError(BaseBundleError):
    """Базовое исключение для вьюх авторизации"""
    error = 'auth.error'


class AuthAlreadyPassedError(BaseAuthError):
    """Авторизация уже прошла успешно, а пользователь пришел повторно"""
    error = 'account.auth_passed'


class AuthSessionOverflowError(BaseAuthError):
    """Пытаемся доавторизовать в куку больше пользователей, чем это разрешено"""
    error = 'sessionid.overflow'


class AuthSessionExpiredError(BaseAuthError):
    """При вызове editsession оказалось, что сессия пользователя больше недействительна"""
    error = 'sessionid.expired'


class AuthInvalidIpError(BaseAuthError):
    """При вызове editsession/createsession оказалось, что у пользователя неправильный ip"""
    error = 'ip.invalid'


class AuthNotAllowedError(BaseAuthError):
    """Создание авторизационных кук запрещено"""
    error = 'auth.not_allowed'


class CodeVerifierNotMatchedError(BaseBundleError):
    error = 'code_verifier.not_matched'


class ContainerInvalidSignatureError(BaseBundleError):
    error = 'container.invalid_signature'


class ContainerInvalidHostError(BaseBundleError):
    error = 'container.invalid_host'


__all__ = (
    'BaseAuthError',
    'AuthAlreadyPassedError',
    'AuthInvalidIpError',
    'AuthSessionExpiredError',
    'AuthSessionOverflowError',
    'AuthNotAllowedError',
    'ContainerInvalidSignatureError',
    'ContainerInvalidHostError',
)
