# -*- coding: utf-8 -*-

from passport.backend.api.forms.base import DeviceInfoForm
from passport.backend.core import validators


class SubmitForm(validators.Schema):
    uid = validators.Uid(not_empty=False, if_missing=None)


AUTH_LINK_PLACEHOLDER = '%AUTH_LINK%'


class SmsTemplateValidator(validators.String):
    min = len(AUTH_LINK_PLACEHOLDER)
    max = 900  # https://wiki.yandex-team.ru/passport/yasms/sendsms/#dlinasoobshhenija
    not_empty = True
    strip = True

    messages = {
        'invalid': 'Template is invalid',
    }

    def _to_python(self, value, state):
        if value.count(AUTH_LINK_PLACEHOLDER) != 1:
            raise validators.Invalid(self.message('invalid', state), value, state)
        return value


class CommitForm(validators.Schema):
    retpath = validators.RetPath(not_empty=True, if_missing=None)

    template = SmsTemplateValidator()


class ExchangeByTrackAuthForwardingForm(DeviceInfoForm):
    client_id = validators.String(not_empty=True)
    client_secret = validators.String(not_empty=True)
