# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.constants import PDD_PARTNER_TOKEN_TYPE
from passport.backend.core import validators


class OpenAuthorizationForm(validators.Schema):
    type = validators.OneOf([PDD_PARTNER_TOKEN_TYPE], not_empty=True)
    retpath = validators.RetPath(ignore_invalid=True, if_missing=None, not_empty=False)


class IssueCodeForAMForm(validators.Schema):
    uid = validators.Uid(not_empty=False, if_missing=None)
    client_id = validators.String(if_missing=None, if_empty=None, strip=True)
    client_secret = validators.String(if_missing=None, if_empty=None, strip=True)

    chained_validators = [
        validators.RequireSet([('client_id', 'client_secret')], allow_empty=True),
    ]


class RecreateYambotTokenForm(validators.Schema):
    uid = validators.Uid(not_empty=True)


class RecreateKolonkishTokenForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    device_id = validators.DeviceId()
    device_name = validators.DeviceName()
