# -*- coding: utf-8 -*-
from passport.backend.api.common.authorization import (
    AUTHORIZATION_SESSION_POLICY_PERMANENT,
    AUTHORIZATION_SESSION_POLICY_SESSIONAL,
)
from passport.backend.core import validators


class SubmitForm(validators.Schema):
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)
    origin = validators.String(if_missing=None)
    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=AUTHORIZATION_SESSION_POLICY_PERMANENT,
    )

    # Поля для МДА
    fretpath = validators.String(if_missing=None, strip=True)
    clean = validators.String(if_missing=None, strip=True)


class CommitForm(validators.Schema):
    csrf_token = validators.String(not_empty=True, strip=True)

    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=None,
        not_empty=False,
    )
