# -*- coding: utf-8 -*-
import json

from passport.backend.api.common.common import create_csrf_token
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.headers import (
    HEADER_CLIENT_COOKIE,
    HEADER_CLIENT_USER_AGENT,
    HEADER_CONSUMER_CLIENT_IP,
)
from passport.backend.core.logging_utils.loggers.statbox import StatboxLogger
from passport.backend.core.utils.decorators import cached_property

from .forms import SubmitForm


class SubmitView(BaseBundleView):

    require_track = False

    track_type = 'authorize'

    required_grants = ['otp.auth']

    basic_form = SubmitForm

    required_headers = (
        HEADER_CLIENT_COOKIE,
        HEADER_CLIENT_USER_AGENT,
        HEADER_CONSUMER_CLIENT_IP,
    )

    @cached_property
    def statbox(self):
        return StatboxLogger(
            track_id=self.track.track_id,
            ip=self.client_ip,
            user_agent=self.user_agent,
            origin=self.track.origin,
            yandexuid=self.cookies.get('yandexuid'),
        )

    def fill_track_with_request_data(self):
        """Записываем в трек все, что относится к запросу"""
        if self.form_values['retpath']:
            self.track.retpath = self.form_values['retpath']
        if self.form_values['origin']:
            self.track.origin = self.form_values['origin']
        if self.form_values['service']:
            self.track.service = self.form_values['service'].slug
        if self.form_values['fretpath']:
            self.track.fretpath = self.form_values['fretpath']
        if self.form_values['clean']:
            self.track.clean = self.form_values['clean']

        self.track.authorization_session_policy = self.form_values['policy']

    def process_request(self, *args, **kwargs):
        self.process_basic_form()
        self.create_track(self.track_type)

        csrf_token = create_csrf_token()
        with self.track_transaction.commit_on_error():
            self.track.csrf_token = csrf_token
            self.track.is_allow_otp_magic = True
            self.fill_track_with_request_data()

        self.response_values.update(track_id=self.track_id, csrf_token=csrf_token)
        self.statbox.log(
            action='submitted',
            type='2fa',
        )
