# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.auth.exceptions import BaseAuthError


class DomainNotHostedError(BaseAuthError):
    """Домен не обслуживается"""
    error = 'domain.not_hosted'


class PDDInvalidLoginFormatError(BaseAuthError):
    """Логин ПДД пользователя не в формате login@your-domain"""
    error = 'login.invalid_format'


class AnswerVerificationRequiredError(BaseAuthError):
    """Требуется ответить на КВ"""
    error = 'answer.required'


class AccountChangedError(BaseAuthError):
    """Процесс пытается завершиться не для того аккаунта, для которого начинался"""
    error = 'account.changed'


class RfcOtpInvalidError(BaseAuthError):
    """Пользователь ввёл неверный одноразовый пароль"""
    error = 'rfc_otp.invalid'


__all__ = (
    'AnswerVerificationRequiredError',
    'DomainNotHostedError',
    'PDDInvalidLoginFormatError',
    'RfcOtpInvalidError',
)
