# -*- coding: utf-8 -*-
from passport.backend.api.common.authorization import (
    AUTHORIZATION_SESSION_POLICY_PERMANENT,
    AUTHORIZATION_SESSION_POLICY_SESSIONAL,
)
from passport.backend.api.forms.base import DeviceInfoForm
from passport.backend.api.forms.register import (
    CAPTCHA_VALIDATION_METHOD,
    PHONE_VALIDATION_METHOD,
)
from passport.backend.core import validators


CHALLENGE_PHONE = 'phone'
CHALLENGE_PHONE_CONFIRMATION = 'phone_confirmation'
CHALLENGE_EMAIL = 'email'


class LoginPasswordForm(validators.Schema):
    login = validators.String(not_empty=True)
    password = validators.String(not_empty=True)


class SubmitAuthorizationForm(validators.Schema):
    login = validators.String(if_missing=None)
    password = validators.String(if_missing=None)

    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)
    origin = validators.String(if_missing=None)
    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=AUTHORIZATION_SESSION_POLICY_PERMANENT,
    )

    # Выставляем, если авторизуемся с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)

    # Поля для МДА
    fretpath = validators.String(if_missing=None, strip=True)
    clean = validators.String(if_missing=None, strip=True)


class SubmitForm(DeviceInfoForm):
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    # Поля для МДА
    fretpath = validators.String(if_missing=None, strip=True)
    clean = validators.String(if_missing=None, strip=True)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)
    origin = validators.String(if_missing=None)
    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=AUTHORIZATION_SESSION_POLICY_PERMANENT,
    )
    with_code = validators.StringBool(if_missing=False, strip=True)


class CommitPasswordForm(validators.Schema):
    login = validators.String(not_empty=True, if_missing=None)
    password = validators.String(not_empty=True, if_missing=None)
    # Выставляем, если авторизуемся с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)
    origin = validators.String(if_missing=None)
    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=AUTHORIZATION_SESSION_POLICY_PERMANENT,
    )
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    # Поля для МДА
    fretpath = validators.String(if_missing=None, strip=True)
    clean = validators.String(if_missing=None, strip=True)


class CommitMagicForm(validators.Schema):
    csrf_token = validators.String(not_empty=True, strip=True)
    need_oauth_token = validators.StringBool(if_missing=False)


class SecureAuthorizationForm(validators.Schema):
    uid = validators.Uid(if_missing=None, not_empty=False)
    password = validators.String(if_missing=None)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    # Выставляем, если авторизуемся с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)


class BaseAccountCompletePddForm(validators.Schema):
    # язык отображаемого интерфейса, автоопределённый
    display_language = validators.DisplayLanguage()

    # EULA обязательна для ПДД
    eula_accepted = validators.StringBool(not_empty=True, strip=True)

    country = validators.CountryCode(if_missing=None)
    timezone = validators.Timezone(if_missing=None)


class AccountCompletePdd(BaseAccountCompletePddForm):
    """Дорегистрация "обычного" ПДД, которому не требуется менять пароль"""
    # Персональная информация
    gender = validators.Gender(if_missing=None)
    birthday = validators.Birthday(if_missing=None)
    force_clean_web = validators.StringBool(if_missing=False)
    firstname = validators.AntiFraudFirstName(not_empty=True)
    lastname = validators.AntiFraudLastName(not_empty=True)
    language = validators.PortalLanguage(if_missing=None)

    # КО/КВ
    question_id = validators.HintQuestionId(if_missing=None)
    question = validators.HintQuestion(if_missing=None)
    answer = validators.HintAnswer()


class AccountCompletePddPassword(AccountCompletePdd):
    """Дорегистрация "обычного" ПДД, которому необходимо сменить пароль"""
    password = validators.String(not_empty=True, strip=True)


class AccountCompleteWorkspacePdd(BaseAccountCompletePddForm):
    """Дорегистрация workspace-пользователя ПДД, которому не требуется менять пароль"""


class AccountCompleteWorkspacePddPassword(AccountCompleteWorkspacePdd):
    """Дорегистрация workspace-пользователя ПДД, которому необходимо сменить пароль"""
    password = validators.String(not_empty=True, strip=True)


class Hint(validators.Schema):
    display_language = validators.DisplayLanguage()

    question_id = validators.HintQuestionId(if_missing=None)
    question = validators.HintQuestion(if_missing=None)
    answer = validators.HintAnswer()


class CompleteAutoregistered(validators.Schema):
    """Валидация пароля будет производиться в ручке"""
    country = validators.CountryCode(if_missing=None)
    language = validators.PortalLanguage(if_missing=None)
    timezone = validators.Timezone(if_missing=None)
    password = validators.String(not_empty=True)
    eula_accepted = validators.StringBool(not_empty=True, strip=True)

    validation_method = validators.OneOf(
        [PHONE_VALIDATION_METHOD, CAPTCHA_VALIDATION_METHOD],
        not_empty=True,
    )


class ChangePasswordForm(validators.Schema):
    """Валидация пароля будет производиться в ручке"""
    password = validators.String(not_empty=True, strip=True)


class ChangePasswordIntranetForm(ChangePasswordForm):
    current_password = validators.String(not_empty=True, strip=True)


class ConfirmSubmitForm(validators.Schema):
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    origin = validators.String(if_missing=None)


class ConfirmCommitPasswordForm(validators.Schema):
    password = validators.String(not_empty=True, if_missing=None, strip=True)


class ConfirmCommitMagicForm(validators.Schema):
    csrf_token = validators.String(not_empty=True, strip=True)


class RfcOtpForm(validators.Schema):
    otp = validators.String(not_empty=True, strip=True)
