# -*- coding: utf-8 -*-
from passport.backend.api.common.format_response import json_response
from passport.backend.api.views.bundle.exceptions import InvalidTrackStateError

from .base import BasePasswordAuthView


class GetStateView(BasePasswordAuthView):

    require_track = True

    track_type = 'authorize'

    def __init__(self):
        super(GetStateView, self).__init__()
        self.cached_response = None

    def dispatch_request(self, **kwargs):

        response = super(GetStateView, self).dispatch_request(**kwargs)
        if self.cached_response:
            return json_response(200, **self.cached_response)

        return response

    def process_request(self, *args, **kwargs):

        self.read_track()

        if not self.track.submit_response_cache:
            raise InvalidTrackStateError()

        self.cached_response = self.track.submit_response_cache
