# -*- coding: utf-8 -*-
from passport.backend.api.common.ip import get_ip_autonomous_system
from passport.backend.api.views.bundle.headers import (
    HEADER_CLIENT_COOKIE,
    HEADER_CLIENT_HOST,
    HEADER_CLIENT_USER_AGENT,
    HEADER_CONSUMER_CLIENT_IP,
)
from passport.backend.api.views.bundle.mixins import BundleAccountGetterMixin
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers.statbox import (
    AntifraudLogger,
    StatboxLogger,
)
from passport.backend.core.utils.decorators import cached_property

from ..base import BasePasswordSubmitAuthView


class BaseMultiStepAuthView(BasePasswordSubmitAuthView, BundleAccountGetterMixin):
    required_headers = (
        HEADER_CLIENT_HOST,
        HEADER_CLIENT_USER_AGENT,
        HEADER_CLIENT_COOKIE,
        HEADER_CONSUMER_CLIENT_IP,
    )
    statbox_type = 'multi_step'

    @cached_property
    def statbox(self):
        return StatboxLogger(
            track_id=self.track_id,
            ip=self.client_ip,
            user_agent=self.user_agent,
            origin=self.track.origin if self.track else self.form_values.get('origin'),
            process_uuid=self.form_values.get('process_uuid'),
            mode='any_auth',
            type=self.statbox_type,
            yandexuid=self.cookies.get('yandexuid'),
            consumer=self.consumer,
        )

    @cached_property
    def antifraud_log(self):
        return AntifraudLogger(
            channel='auth',
            sub_channel=settings.ANTIFRAUD_AUTH_SUB_CHANNEL,
            ip=self.client_ip,
            AS=get_ip_autonomous_system(self.client_ip),
            user_agent=self.user_agent,
            origin=self.track.origin if self.track else self.form_values.get('origin'),
            external_id='track-{}'.format(self.track_id),
            uid=self.account.uid if self.account else None,
            service_id='login',
        )
