# -*- coding: utf-8 -*-
from passport.backend.api.common.authorization import (
    AUTHORIZATION_SESSION_POLICY_PERMANENT,
    AUTHORIZATION_SESSION_POLICY_SESSIONAL,
)
from passport.backend.api.views.bundle.mobile.forms import BaseStartForm as BaseMobileStartForm
from passport.backend.core import validators


SEND_TO_EMAIL = 'email'


class MultiStepStartForm(BaseMobileStartForm):
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    service = validators.Service(if_missing=None, ignore_unknown_service=True)
    origin = validators.String(if_missing=None)
    policy = validators.OneOf(
        [
            AUTHORIZATION_SESSION_POLICY_SESSIONAL,
            AUTHORIZATION_SESSION_POLICY_PERMANENT,
        ],
        if_missing=AUTHORIZATION_SESSION_POLICY_PERMANENT,
    )
    # Признак авторизации с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)
    # Поля для МДА
    fretpath = validators.String(if_missing=None, strip=True)
    clean = validators.String(if_missing=None, strip=True)
    # параметр для провязки с логами фронта
    process_uuid = validators.String(if_missing=None, strip=True)

    login = validators.LooseLoginValidator()

    # Идентификатор трека от соц. авторизации. Передаётся, чтобы предотвратить
    # регистрацию соц. аккаунта, когда велика вероятность, что у пользователя
    # уже есть аккаунт в Яндексе.
    social_track_id = validators.TrackId(if_missing=None)

    # Идентификатор трека от предыдущего процесса (например, показа саджеста)
    old_track_id = validators.TrackId(if_missing=None)

    # Эти параметры родительской формы тут не обязательны
    display_language = validators.CaptchaDisplayLanguage(if_missing=None)
    x_token_client_id = validators.String(if_missing=None)
    x_token_client_secret = validators.String(if_missing=None)

    # Признак, что сервис, в котором логиниться пользователь, умеет работать со
    # школьниками.
    allow_scholar = validators.StringBool(if_missing=False)

    with_2fa_pictures = validators.StringBool(if_missing=False, strip=True)


class MultiStepPasswordForm(validators.Schema):
    password = validators.String(not_empty=True, strip=True)


class MultiStepMagicForm(validators.Schema):
    csrf_token = validators.String(not_empty=True, strip=True)


class MultiStepMagicLinkSendForm(validators.Schema):
    send_to = validators.OneOf(
        [
            SEND_TO_EMAIL,
        ],
        if_missing=SEND_TO_EMAIL,
        not_empty=True,
        strip=True,
    )


class MultiStepMagicLinkConfirmForm(validators.Schema):
    secret = validators.MagicLinkSecretKey()
    redirect = validators.StringBool(if_missing=False, strip=True)


class MultiStepMagicLinkConfirmRegistrationForm(validators.Schema):
    secret = validators.String(
        not_empty=True,
        strip=True,
        min=validators.MAGIC_LINK_SECRET_HEX_LENGTH,
        max=validators.MAGIC_LINK_SECRET_HEX_LENGTH,
    )
    redirect = validators.StringBool(if_missing=False, strip=True)


class MultiStepMagicLinkInfoForm(validators.Schema):
    avatar_size = validators.String(not_empty=True, strip=True, max=100)


class MultiStepMagicLinkExpireMessageForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    message_id = validators.String(not_empty=True)
    device_name = validators.String(if_missing=None)


class MultiStepAuthAfterLoginRestoreForm(validators.Schema):
    uid = validators.Uid()
    firstname = validators.FirstName(not_empty=True)
    lastname = validators.LastName(not_empty=True)


class MultiStepAuthAfterLoginRestore2Form(validators.Schema):
    uid = validators.Uid()


class MultiStepEmailCodeCommitForm(validators.Schema):
    code = validators.String(not_empty=True, strip=True)
