# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class UidRejectedError(BaseBundleError):
    """
    В ручку choose пришел UID такой, что по нему и userid нельзя получить профиль,
    которым разрешено авторизоваться. Это может произойти, если во время выбора
    аккаунта пользователь оторвал возможность авторизоваться у аккаунта или вообще его удалил.
    Или же пользователь вручную подменил UID в запросе.
    """
    error = 'uid.rejected'


class NameRequiredError(BaseBundleError):
    """
    Не удалось получить от социалки имя и фамилию.
    """
    error = 'name.required'


class BrokerFailedError(BaseBundleError):
    """
    Из брокера пришли в /callback со статусом !=ok
    """
    error = 'broker.failed'


class ProviderInvalidError(BaseBundleError):
    """
    В /callback пришли с данными по провайдеру, код которого не в списке разрешенных.

    """
    error = 'provider.invalid'


class ApplicationInvalidError(BaseBundleError):
    """
    Запрещается аутентицировать по токенам от данного приложения.
    """
    error = 'application.invalid'


class InvalidProviderTokenError(BaseBundleError):
    """
    Передан недействительный токен.
    """
    error = 'provider_token.invalid'
