# -*- coding: utf-8 -*-

from ...states import BaseState


class BaseSocialState(BaseState):
    """
    Базовый класс состояний социальной авторизации/регистрации.
    """


class RedirectToBrokerWithAuth(BaseSocialState):
    """
    Отправляем пользователя в брокер, у него есть валидная авторизация.
    """
    state = 'broker.with_auth'


class RedirectToBrokerWithoutAuth(BaseSocialState):
    """
    Отправляем пользователя в брокер, у него нет валидной авторизации.
    """
    state = 'broker.without_auth'


class RedirectToChoose(BaseSocialState):
    """
    Отправляем пользователя /choose.
    """
    state = 'choose'


class RedirectToRegister(BaseSocialState):
    """
    Отправляем пользователя в /register.
    """
    state = 'register'


class RedirectToRetpath(BaseSocialState):
    """
    Отправляем пользователя на retpath, проставляем ему куки.
    """
    state = 'auth'


class SuggestSocialState(BaseSocialState):
    state = 'suggest'
