# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.auth.exceptions import BaseAuthError


class SamlResponseInvalidError(BaseAuthError):
    """Присланный ответ не прошел валидацию"""
    error = 'samlresponse.invalid'


class SamlRequestInvalidError(BaseAuthError):
    """Присланный запрос не прошел валидацию"""
    error = 'samlrequest.invalid'


class SamlSettingsError(BaseAuthError):
    """Настройка SP/IdP неверна"""
    error = 'saml_settings.invalid'


class SamlEmailExistError(BaseAuthError):
    """Пользователь с такой почтой уже существует"""
    error = 'email.exists'


class SamlEmailUnsupportableDomainError(BaseAuthError):
    """Почта пользователя на другом домене"""
    error = 'email.unsupportable_domain'


class SamlEmailNoInResponseError(BaseAuthError):
    """IdP не прислал почту пользователя в ответе"""
    error = 'email.no_in_response'


class SamlResponseExternalError(BaseAuthError):
    """Из ADFS пришла ошибка, пользователю необходимо обратиться к своему администратору"""
    error = 'saml.request_your_admin'


class SamlInvalidSignatureError(BaseAuthError):
    """Ответ/запрос из ADFS не прошел валидацию подписи"""
    error = 'saml.invalid_signature'


class SamlRegistrationNotSupportedError(BaseAuthError):
    """Запрещена регистрация аккаунта при входе, необходимо использовать scim для добавления пользователей"""
    error = 'saml.registration_not_supported'
