# -*- coding: utf-8 -*-
from passport.backend.core import validators
from passport.backend.core.utils.pkce import CODE_CHALLENGE_METHOD_SHA256


class SubmitForm(validators.Schema):
    code_challenge = validators.String(not_empty=True, if_missing=None, strip=True)
    code_challenge_method = validators.OneOf(
        [CODE_CHALLENGE_METHOD_SHA256],
        if_missing=None,
    )

    chained_validators = [
        validators.RequireSet([('code_challenge', 'code_challenge_method')], allow_empty=True),
    ]


class CommitForm(validators.Schema):
    saml_response = validators.Base64String(not_empty=True, decode=False, strip=True)
    relay_state = validators.String(not_empty=True, strip=True)


class CompleteFederalForm(validators.Schema):
    eula_accepted = validators.StringBool(not_empty=True, strip=True)


class LogoutFederalForm(validators.Schema):
    saml_request = validators.Base64String(not_empty=True, decode=False, strip=True)
    relay_state = validators.String(not_empty=True, if_missing=None, strip=True)
