# -*- coding: utf-8 -*-
from passport.backend.core import validators
from six.moves import xmlrpc_client


class ListPaymentMethodsForm(validators.Schema):
    ym_schema = validators.String(not_empty=True, if_missing=None)


class CreateBindingForm(validators.Schema):
    return_path = validators.String(not_empty=True, if_missing=None)
    back_url = validators.String(not_empty=True, if_missing=None)
    timeout = validators.Int(not_empty=True, if_missing=None, min=0, max=xmlrpc_client.MAXINT)
    currency = validators.String(not_empty=True, if_missing=None)
    region_id = validators.Int(not_empty=True, if_missing=None, min=xmlrpc_client.MININT, max=xmlrpc_client.MAXINT)
    lang = validators.String(not_empty=True, if_missing=None)
    template_tag = validators.String(not_empty=True, if_missing=None)
    domain_sfx = validators.String(not_empty=True, if_missing=None)


class DoBindingForm(validators.Schema):
    purchase_token = validators.String(not_empty=True)


class CheckBindingForm(DoBindingForm):
    pass


class UnbindCardForm(validators.Schema):
    card = validators.String(not_empty=True)
