# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class Trust3DSNotPassedError(BaseBundleError):
    """Запрошенный 3DS ещё не пройден"""
    error = '3ds.not_passed'


class Trust3DSFailedError(BaseBundleError):
    """Не удалось пройти 3DS"""
    error = '3ds.failed'


class Trust3DSNotEnoughFundsError(BaseBundleError):
    """Не удалось пройти 3DS. Недостаточно средств"""
    error = '3ds.not_enough_funds'
