# -*- coding: utf-8 -*-
from passport.backend.api.common.processes import ALL_PROCESSES
from passport.backend.api.views.bundle.base import BaseBundleView


class CaptchaStatusView(BaseBundleView):
    required_grants = ['captcha.*']
    require_track = True
    allowed_processes = ALL_PROCESSES

    def process_request(self):
        self.read_track()

        self.response_values.update({
            'is_required': self.track.is_captcha_required,
            'is_generated': bool(self.track.captcha_key),
            'is_checked': bool(self.track.is_captcha_checked),
            'is_recognized': bool(self.track.is_captcha_recognized),
        })
