# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.auth.exceptions import BaseAuthError


class ChallengeNotEnabledError(BaseAuthError):
    """Пользователь пытается пройти челленж, который ему недоступен"""
    error = 'challenge.not_enabled'


class ChallengeLimitExceededError(BaseAuthError):
    """Пользователь исчерпал попытки прохождения челленжа"""
    error = 'challenge.limit_exceeded'


class ChallengeNotPassedError(BaseAuthError):
    """Пользователь ввёл неверный ответ на челленж"""
    error = 'challenge.not_passed'


class CardIdNotFoundError(BaseAuthError):
    """У текущего пользователя нет карты с указанным id"""
    error = 'card_id.not_found'
