# -*- coding: utf-8 -*-
from passport.backend.core import validators


CHALLENGE_PHONE = 'phone'
CHALLENGE_PHONE_CONFIRMATION = 'phone_confirmation'
CHALLENGE_DICTATION_PHONE_CONFIRMATION = 'dictation'
CHALLENGE_EMAIL = 'email'
CHALLENGE_WEBAUTHN = 'webauthn'
CHALLENGE_QUESTION = 'question'
CHALLENGE_PUSH_2FA = 'push_2fa'
CHALLENGE_3DS = '3ds'
CHALLENGE_EMAIL_CODE = 'email_code'


class BaseChallengeForm(validators.Schema):
    can_send_sms = validators.StringBool(if_missing=True, strip=True)


class ChallengeStandaloneCreateTrackForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    retpath = validators.RetPath(not_empty=True)
    antifraud_tags = validators.JSONValidator(if_missing=[], not_empty=False, strip=True)
    antifraud_external_id = validators.String(if_missing=None)  # TODO: после PASSP-34424 сделать обязательным
    card_id_for_3ds = validators.String(if_missing=None, not_empty=False, strip=True)


class ChallengeCommitForm(BaseChallengeForm):
    challenge = validators.OneOf(
        [
            CHALLENGE_DICTATION_PHONE_CONFIRMATION,
            CHALLENGE_EMAIL,
            CHALLENGE_EMAIL_CODE,
            CHALLENGE_PHONE,
            CHALLENGE_PHONE_CONFIRMATION,
            CHALLENGE_WEBAUTHN,
            CHALLENGE_QUESTION,
            CHALLENGE_PUSH_2FA,
            CHALLENGE_3DS,
        ],
        not_empty=True,
        strip=True,
    )
    answer = validators.String(if_missing=None, if_empty=None, strip=True)

    chained_validators = [
        validators.RequireIfEquals(['answer'], 'challenge', CHALLENGE_PHONE),
        validators.RequireIfEquals(['answer'], 'challenge', CHALLENGE_EMAIL),
    ]


class SendAuthEmailForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    device_name = validators.String(not_empty=True, if_missing=None, strip=True)
    is_challenged = validators.StringBool(if_missing=True, strip=True)
