# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class BaseChangeAvatarError(BaseBundleError):
    """ Базовая ошибка страницы смены аватара """


class InvalidAvatarSizeError(BaseChangeAvatarError):
    """ Некорректный размер загружаемого аватара """
    error = 'change_avatar.invalid_image_size'


class InvalidFileSizeError(BaseChangeAvatarError):
    """ Некорректный размер загружаемого файла """
    error = 'change_avatar.invalid_file_size'


class InvalidUrlError(BaseChangeAvatarError):
    """ Yapic ответил, что url невалидный"""
    error = 'change_avatar.invalid_url'


class InvalidYapicResponse(BaseChangeAvatarError):
    """ Некорректный ответ Yapic """
    error = 'change_avatar.invalid_yapic_response'


class MDSTemporaryError(BaseChangeAvatarError):
    """ MDS долго отвечает, запрос можно повторить """
    error = 'change_avatar.mds_temporary_error'
