# -*- coding: utf-8 -*-

from passport.backend.core import validators


class InitForm(validators.Schema):
    uid = validators.Uid(if_missing=None)


class UploadForm(validators.Schema):
    url = validators.SimpleUrlValidator(if_missing=None, strip=True, not_empty=True, max=1024)
    # is_temp - признак того, что мы загрузили аватарку в диалоговом окне Паспорта, но не нажали "сохранить"
    # (поэтому надо залить в mds, но не менять дефолт в Паспорте)
    is_temp = validators.StringBool(if_missing=False, if_empty=False, strip=True)
    chained_validators = [
        validators.FileUploadSchemaValidator(
            file=validators.SingleFileUploadValidator(
                if_empty=None,
                allowed_ext=('png', 'gif', 'jpg', 'jpeg'),
            ),
        ),
        validators.RequireSome(some_fields=('url', 'file')),
    ]


class UploadCommonForm(UploadForm):
    uid = validators.Uid(if_missing=None)
    avatar_size = validators.String(strip=True, if_missing='normal')
