# -*- coding: utf-8 -*-

from passport.backend.core import validators


class ChangePasswordSubmitForm(validators.Schema):
    origin = validators.String(if_missing=None, not_empty=False, strip=True)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)

    # Выставляем, если авторизуемся с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)


class ChangePasswordCommitForm(validators.Schema):
    """Форма смены пароля пользователя"""
    current_password = validators.String(not_empty=True)
    password = validators.String(not_empty=True)

    # Выставляем, если авторизуемся с /for/...
    is_pdd = validators.StringBool(if_missing=False, strip=True)

    revoke_web_sessions = validators.StringBool(if_missing=True, strip=True)
    revoke_tokens = validators.StringBool(if_missing=True, strip=True)
    revoke_app_passwords = validators.StringBool(if_missing=True, strip=True)


class ChangePasswordCommitIntranetForm(ChangePasswordCommitForm):
    revoke_web_sessions = validators.StringBool(if_missing=False, strip=True)
    revoke_tokens = validators.StringBool(if_missing=False, strip=True)
    revoke_app_passwords = validators.StringBool(if_missing=False, strip=True)


class ChangePasswordOptionalLogoutForm(validators.Schema):
    """Форма опционального выхода после смены пароля"""
    revoke_web_sessions = validators.StringBool(if_missing=False, strip=True)
    revoke_tokens = validators.StringBool(if_missing=False, strip=True)
    revoke_app_passwords = validators.StringBool(if_missing=False, strip=True)


class ChangeKinopoiskPasswordSubmitForm(validators.Schema):
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)


class ChangeKinopoiskPasswordCommitForm(validators.Schema):
    """Форма смены пароля для пользователя Кинопоиска"""
    current_password = validators.String(not_empty=True)
    password = validators.String(not_empty=True)

    revoke_web_sessions = validators.StringBool(if_missing=True, strip=True)
    revoke_tokens = validators.StringBool(if_missing=True, strip=True)
    revoke_app_passwords = validators.StringBool(if_missing=True, strip=True)


class ChangeScholarPasswordForm(validators.Schema):
    password = validators.String(not_empty=True, strip=True)
    revoke_credentials = validators.StringBool(if_missing=False, strip=True)
    uid = validators.Uid()
