# -*- coding: utf-8 -*-

from passport.backend.api.forms.register import (
    CAPTCHA_VALIDATION_METHOD,
    PHONE_VALIDATION_METHOD,
)
from passport.backend.core import validators
from passport.backend.core.conf import settings


class CompleteStatusForm(validators.Schema):
    completion_postponed_at = validators.Unixtime(if_missing=None)

    def __init__(self, *args, **kwargs):
        super(CompleteStatusForm, self).__init__(*args, **kwargs)
        self.add_field(
            'language',
            validators.PortalLanguage(
                if_missing=settings.PASSPORT_DEFAULT_TLD,  # если значение не передано
                default_language=None,  # если переданное значение не в списке поддерживаемых языков
            ),
        )


class CompleteSubmitForm(validators.Schema):
    can_handle_neophonish = validators.StringBool(if_missing=True)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)


class CompleteCommitBaseForm(validators.Schema):
    # язык, отображаемого интерфейса, автоопределённый
    display_language = validators.DisplayLanguage()

    # Персональная информация
    force_clean_web = validators.StringBool(if_missing=False)
    firstname = validators.AntiFraudFirstName(if_missing=None)
    lastname = validators.AntiFraudLastName(if_missing=None)

    # язык, который выбрал пользователь или автоопределённый
    language = validators.PortalLanguage(if_missing=None)
    country = validators.CountryCode(if_missing=None)
    gender = validators.Gender(if_missing=None)
    birthday = validators.Birthday(if_missing=None)
    timezone = validators.Timezone(if_missing=None)

    # КО/КВ
    question_id = validators.HintQuestionId(if_missing=None)
    question = validators.HintQuestion(if_missing=None)
    answer = validators.HintAnswer(if_missing=None)

    validation_method = validators.OneOf(
        [PHONE_VALIDATION_METHOD, CAPTCHA_VALIDATION_METHOD],
        if_missing=None,
        not_empty=False,
    )


class CompleteCommitSocialForm(validators.Schema):
    password = validators.String(not_empty=True)


class CompleteCommitSocialWithLoginForm(CompleteCommitSocialForm):
    login = validators.Login()
    chained_validators = [
        validators.Availability(),
    ]


class CompleteCommitLiteForm(validators.Schema):
    # EULA обязательна для лайтов
    eula_accepted = validators.StringBool(not_empty=True, strip=True)
    login = validators.Login()

    # Пароль не для выставления на аккаунт, а для проверки.
    password = validators.String(not_empty=True)

    chained_validators = [
        validators.Availability(),
    ]


class CompleteCommitLiteForcedForm(validators.Schema):
    # EULA обязательна для лайтов
    eula_accepted = validators.StringBool(not_empty=True, strip=True)
    login = validators.Login()

    chained_validators = [
        validators.Availability(),
    ]


class CompleteCommitNeophonishForm(validators.Schema):
    login = validators.Login()
    password = validators.String(not_empty=True)

    chained_validators = [
        validators.Availability(),
    ]


__all__ = (
    'CompleteSubmitForm',
    'CompleteCommitBaseForm',
    'CompleteCommitSocialForm',
    'CompleteCommitSocialWithLoginForm',
    'CompleteCommitLiteForm',
    'CompleteCommitLiteForcedForm',
    'CompleteCommitNeophonishForm',
)
