# -*- coding: utf-8 -*-
import logging

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.core.cookies import cookie_l

from .exceptions import CookieInvalid
from .forms import Cookie


log = logging.getLogger('passport.api.view.bundle.cookies')


class ParseCookieL(BaseBundleView):

    required_grants = ['cookies.parse_l']

    basic_form = Cookie

    def process_request(self):
        self.process_basic_form()
        try:
            cookie_info = cookie_l.CookieL().unpack(self.form_values['cookie'])
        except cookie_l.CookieLUnpackError as e:
            log.debug('Error while unpacking cookie: %s', e.message)
            raise CookieInvalid()

        self.response_values.update(cookie_info)
