# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.exceptions import BaseBundleError


class ConflictDevicePublicKeyError(BaseBundleError):
    error = 'device_public_key.conflict'


class NotFoundDevicePublicKeyError(BaseBundleError):
    error = 'device_public_key.not_found'


class InvalidOwnerDevicePublicKeyError(BaseBundleError):
    error = 'device_public_key.owner_invalid'


class CheckFailedDevicePublicKeyError(BaseBundleError):
    error = 'device_public_key.check_failed'


class NeedNewNonceError(BaseBundleError):
    error = 'nonce.need_new'
