# -*- coding: utf-8 -*-

import re

from passport.backend.core import validators


class OwnerValidator(validators.ASCIIString):
    strip = True
    not_empty = True


class PublicKeyValidator(validators.ASCIIString):
    # Длина определяется типом столбца public_key таблицы device_public_key
    max = 60000
    allow_new_lines = True
    strip = True
    not_empty = True


class CreateForm(validators.Schema):
    device_id = validators.DriveDeviceIdValidator()
    owner = OwnerValidator()
    public_key = PublicKeyValidator()
    check_nonce = validators.SignatureValidator()
    check_signature = validators.SignatureValidator()


class UpdateForm(validators.Schema):
    device_id = validators.DriveDeviceIdValidator()
    owner = OwnerValidator()
    public_key = PublicKeyValidator()
    check_nonce = validators.SignatureValidator()
    check_signature = validators.SignatureValidator()
    check_nonce_sign_space = validators.BlackboxSignSpaceValidator()


class DeleteForm(validators.Schema):
    device_id = validators.DriveDeviceIdValidator()
    owner = OwnerValidator()
