# -*- coding: utf-8 -*-
from passport.backend.api.email_validator.mixins import EmailValidatorMixin
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.mixins import (
    BundleAccountGetterMixin,
    BundleAccountPropertiesMixin,
)
from passport.backend.core.logging_utils.loggers import StatboxLogger
from passport.backend.core.utils.decorators import cached_property


BASIC_GRANT = 'email_bundle.base'


class BaseEmailBundleView(BaseBundleView,
                          BundleAccountGetterMixin,
                          BundleAccountPropertiesMixin,
                          EmailValidatorMixin):
    required_grants = [BASIC_GRANT]

    @cached_property
    def statbox(self):
        return StatboxLogger(
            mode='email_bundle',
            consumer=self.consumer,
        )

    def process_request(self):
        if self.basic_form:
            self.process_basic_form()
        self.process()

    def process(self):
        raise NotImplementedError  # pragma: no cover
