# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import (
    BaseBundleError,
    ResourceUnavailableError,
)


class BaseEmailBundleError(BaseBundleError):
    """ Базовый класс ошибок email валидатора """


class EmailValidatorFailedError(ResourceUnavailableError):
    """ Ошибка ответа email валидатора """
    error = 'email.validator_failed'


class EmailValidatorAlreadySentError(BaseEmailBundleError):
    """ Ошибка: письмо валидации уже отослано """
    error = 'email.already_sent'


class EmailValidatorKeyCheckLimitExceededError(BaseEmailBundleError):
    """ Превышено число попыток проверки короткого кода """
    error = 'email.key_check_limit_exceeded'


class EmailNotFoundError(BaseEmailBundleError):
    """ Переданный емейл не был привязан к аккаунту """
    error = 'email.not_found'
