# -*- coding: utf-8 -*-
from passport.backend.core import validators


class SendConfirmationEmailFormV1(validators.Schema):
    email = validators.ComprehensiveEmailValidator()
    email_retpath = validators.RetPath(not_empty=True, if_missing=None)
    language = validators.ConfirmationEmailLanguage(not_empty=True, if_missing=None)


class SetupConfirmedEmailFormV1(validators.Schema):
    uid = validators.Uid(not_empty=True)
    email = validators.ComprehensiveEmailValidator()

    is_silent = validators.StringBoolean(if_missing=None, not_empty=True)


class DeleteEmailByAdminForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    email = validators.ComprehensiveEmailValidator()

    admin_name = validators.String(not_empty=True, strip=True)
    comment = validators.String(not_empty=True, if_missing='', strip=True)


class UidForm(validators.Schema):
    uid = validators.Uid(if_missing=None)


class EmailForm(UidForm):
    email = validators.ComprehensiveEmailValidator()


class SendConfirmationEmailForm(EmailForm):
    validator_ui_url = validators.RetPath(not_empty=True)
    language = validators.PortalLanguage(not_empty=True, if_missing=None)
    retpath = validators.RetPath(not_empty=True)
    code_only = validators.StringBoolean(if_missing=False, not_empty=True)
    is_safe = validators.StringBoolean(if_missing=True, not_empty=True)


class ConfirmEmailForm(UidForm):
    key = validators.String(not_empty=True)


class SetupConfirmedEmailForm(EmailForm):
    is_safe = validators.StringBoolean(if_missing=None, not_empty=True)


class CheckEmailOwnershipConfirmForm(validators.Schema):
    code = validators.String(not_empty=True)
