# -*- coding: utf-8 -*-

import logging

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.family.forms import FamilyBasicForm
from passport.backend.api.views.bundle.headers import HEADER_CONSUMER_CLIENT_IP
from passport.backend.api.views.bundle.mixins import BundleAccountGetterMixin
from passport.backend.api.views.bundle.mixins.family import BundleFamilyMixin
from passport.backend.api.views.bundle.mixins.kiddish import BundleKiddishMixin
from passport.backend.core.runner.context_managers import DELETE
from passport.backend.core.ydb.processors.family_invite import delete_family_invites_by_family_id


log = logging.getLogger('passport.api.view.bundle.family.delete')


class DeleteFamilyView(
    BundleKiddishMixin,
    BundleFamilyMixin,
    BundleAccountGetterMixin,
    BaseBundleView,
):
    basic_form = FamilyBasicForm

    required_headers = (
        HEADER_CONSUMER_CLIENT_IP,
    )

    required_grants = ['family.delete']
    by_uid_grant = 'family.delete_by_uid'

    def __init__(self):
        super(DeleteFamilyView, self).__init__()

        # Аккаунты-ребёнкиши из семьи
        self.kids = None

    def process_request(self):
        self.process_basic_form()

        # Загрузить аккаунт
        self.get_account_from_uid_or_session(
            by_uid_grant=self.by_uid_grant,
            multisession_uid=self.form_values['multisession_uid'],
            enabled_required=True,
            get_family_info=True,
        )

        # Проверить, что пользователь - админ семьи и получить информацию из ЧЯ
        self.assert_is_family_admin(load_family_info=True)

        self.load_kids()
        self.start_kids_deletion()

        # Сначала чистим инвайты, иначе ретрай в случае фейла основной БД не пройдёт
        # из-за отсутствия семейной информации
        delete_family_invites_by_family_id(self.family_info.family_id)

        # Удалить семью
        events = {'action': 'family_delete', 'consumer': self.consumer}
        with DELETE(self.family_info, self.request.env, events):
            pass

        log.debug('Deleted family=%s admin=%s'.format(
            self.family_info.family_id,
            self.account.uid,
        ))
