# -*- coding: utf-8 -*-

import logging

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.constants import (
    AUTHENTICATION_MEDIA_SESSION,
    AUTHENTICATION_MEDIA_UID,
    AUTHENTICATION_MEDIA_USER_TICKET,
    FAMILY_MANAGE_SCOPE,
    SESSIONID_SCOPE,
)
from passport.backend.api.views.bundle.exceptions import AccountInvalidTypeError
from passport.backend.api.views.bundle.family.forms import DeleteChildForm
from passport.backend.api.views.bundle.mixins import BundleAccountGetterMixin
from passport.backend.api.views.bundle.mixins.child import BundleChildMixin
from passport.backend.api.views.bundle.mixins.common import BundleTvmUserTicketMixin
from passport.backend.api.views.bundle.mixins.family import BundleFamilyMixin


log = logging.getLogger(__name__)


class DeleteChildView(
    BundleChildMixin,
    BundleFamilyMixin,
    BundleAccountGetterMixin,
    BundleTvmUserTicketMixin,
    BaseBundleView,
):
    basic_form = DeleteChildForm
    required_grants = ['family.delete_child']
    by_uid_grant = 'family.delete_child_by_uid'

    def check_prerequires(self):
        self.get_account_from_available_media(
            by_uid_grant=self.by_uid_grant,
            enabled_media=(
                AUTHENTICATION_MEDIA_SESSION,
                AUTHENTICATION_MEDIA_UID,
                AUTHENTICATION_MEDIA_USER_TICKET,
            ),
            get_family_info=True,
            multisession_uid=self.form_values.get('multisession_uid'),
            required_scope=(FAMILY_MANAGE_SCOPE, SESSIONID_SCOPE),
        )
        # является ли этот персонаж админом, значит может управлять семьей в ней
        self.assert_is_family_admin(load_family_info=True)
        # и сам не является ребенком
        if self.account.is_child:
            raise AccountInvalidTypeError()

        self.get_account_by_uid(
            self.form_values.get('child_uid'),
            enabled_required=False,
            get_family_info=True,
        )
        self.check_child_consistent(self.account)

    def process_request(self):
        self.process_basic_form()

        self.check_prerequires()
        self.start_child_deletion()
