# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.change_avatar.forms import UploadForm
from passport.backend.core import (
    Undefined,
    validators,
)


class FamilyBasicForm(validators.Schema):
    multisession_uid = validators.Uid(if_missing=None)
    uid = validators.Uid(if_missing=None)


class FamilyMemberUidForm(FamilyBasicForm):
    member_uid = validators.Uid()


class FamilyInviteForm(FamilyBasicForm):
    invite_id = validators.Uuid()


class FamilyInviteOnlyForm(validators.Schema):
    invite_id = validators.Uuid()


class FamilyCreateInviteForm(FamilyBasicForm):
    email = validators.Email(if_missing=None)
    sms_phone = validators.String(if_missing=None, not_empty=True, strip=True)
    sms_phone_country = validators.CountryCode(if_missing=None)
    scenario = validators.String(if_missing=None, not_empty=True)

    chained_validators = [
        validators.RequireSome(
            ['sms_phone', 'email'],
            min_=0, max_=1,
        ),
        validators.PhoneNumber(phone_number_key='sms_phone', country_key='sms_phone_country'),
    ]


class FamilyRemoveMemberForm(FamilyBasicForm):
    place_id = validators.Regex(r'f\d+:\d+', if_missing=None)
    member_uid = validators.Uid(if_missing=None)

    chained_validators = [
        validators.RequireSome(
            ['place_id', 'member_uid'],
            min_=1, max_=1,
        ),
    ]


class CreateKiddishForm(FamilyBasicForm):
    pre_validators = [
        validators.GroupDisplayName(),
    ]

    avatar_id = validators.AvatarId(if_missing=None)
    birthday = validators.Birthday(if_missing=None)
    content_rating_class = validators.ContentRatingClass(if_missing=None)
    display_name = validators.UserDefinedDisplayName(antifraud_enabled=False)
    family_id = validators.FamilyId(if_missing=None)
    firstname = validators.FirstName(if_missing=None)
    gender = validators.Gender(if_missing=None)
    lastname = validators.LastName(if_missing=None)
    music_content_rating_class = validators.ContentRatingClass(if_missing=None)
    video_content_rating_class = validators.ContentRatingClass(if_missing=None)

    chained_validators = [
        validators.RequireSome(['display_name'], rule_name='display_name'),
    ]


class DeleteKiddishForm(FamilyBasicForm):
    kiddish_uid = validators.Uid()


class ChangeKiddishForm(FamilyBasicForm):
    pre_validators = [
        validators.GroupDisplayName(),
    ]

    avatar_id = validators.AvatarId(if_empty=None, if_missing=Undefined, not_empty=False)
    birthday = validators.Birthday(if_missing=Undefined)
    content_rating_class = validators.ContentRatingClass(if_empty=None, if_missing=Undefined, not_empty=False)
    display_name = validators.UserDefinedDisplayName(antifraud_enabled=False)
    firstname = validators.FirstName(if_missing=Undefined)
    gender = validators.Gender(if_missing=Undefined)
    kiddish_uid = validators.Uid()
    lastname = validators.FirstName(if_missing=Undefined)
    music_content_rating_class = validators.ContentRatingClass(if_empty=None, if_missing=Undefined, not_empty=False)
    video_content_rating_class = validators.ContentRatingClass(if_empty=None, if_missing=Undefined, not_empty=False)


class DeleteChildForm(FamilyBasicForm):
    child_uid = validators.Uid()


class ChangeChildAvatarForm(UploadForm, FamilyBasicForm):
    child_uid = validators.Uid()
    avatar_size = validators.String(strip=True, if_missing='normal')


class FamilyInvitesInfoForm(validators.Schema):
    uid = validators.Uid()


class CreateChildForm(validators.Schema):
    login = validators.Login()
    password = validators.String(not_empty=True)
    birthday = validators.Birthday(not_empty=True)
    firstname = validators.FirstName(not_empty=True)
    lastname = validators.LastName(not_empty=True)
    content_rating_class = validators.ContentRatingClass(not_empty=True)
    eula_accepted = validators.StringBool(not_empty=True, strip=True)
    gender = validators.Gender(if_missing=None)
    force_clean_web = validators.StringBool(not_empty=True)
    avatar_id = validators.AvatarId(if_empty=None, if_missing=Undefined, not_empty=False)
