# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.family.forms import FamilyInviteOnlyForm
from passport.backend.api.views.bundle.mixins import BundleFamilyMixin


class InviteInfoView(BaseBundleView, BundleFamilyMixin):
    basic_form = FamilyInviteOnlyForm

    required_grants = ['family.invite_info']

    def process_request(self):
        self.process_basic_form()

        self.response_values.update(
            self.family_invite_to_response(
                self.find_invite(self.form_values['invite_id']),
            ),
        )
